/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__DRIVER_INTERFACE_H
#define MX__DRIVER_INTERFACE_H

#include "mx_io.h"
#include "mx__fops.h"

MX_FUNC(mx_return_t) mx__crashdump(mx_endpt_handle_t handle, mx_crashdump_t *p);
MX_FUNC(mx_return_t) mx__get_instance_count(mx_endpt_handle_t handle,
					    uint32_t *p);
MX_FUNC(mx_return_t) mx__get_max_instance(mx_endpt_handle_t handle,
					  uint32_t *p);
MX_FUNC(mx_return_t) mx__get_nic_id(mx_endpt_handle_t handle,
				    mx_get_nic_id_t *p);
MX_FUNC(mx_return_t) mx__get_num_handles(mx_endpt_handle_t handle, uint32_t *p);
MX_FUNC(mx_return_t) mx__get_max_rdma_windows(mx_endpt_handle_t handle,
					      int32_t *p);
MX_FUNC(mx_return_t) mx__get_copyblocks(mx_endpt_handle_t handle,
					mx_get_copyblock_t *p);
MX_FUNC(mx_return_t) mx__set_endpoint(mx_endpt_handle_t handle,
				      mx_set_endpt_t *p);
MX_FUNC(mx_return_t) mx__get_counters(mx_endpt_handle_t handle,
				      uint32_t board_number,
				      uint32_t counters[MX_MAX_STR_LEN]);
#if MX_DRIVER_API_MAGIC >= 0x500
MX_FUNC(mx_return_t) mx__get_some_counters(mx_endpt_handle_t handle,
					   mx_get_some_counters_t *p);
#endif
MX_FUNC(mx_return_t) mx__clear_counters(mx_endpt_handle_t handle,
					uint32_t board_number);
MX_FUNC(mx_return_t) mx__register(mx_endpt_handle_t handle, mx_reg_t *p);
MX_FUNC(mx_return_t) mx__deregister(mx_endpt_handle_t handle,
				    uint32_t mcp_handle);
MX_FUNC(mx_return_t) mx__get_counters_strings(mx_endpt_handle_t handle,
					      uint32_t board_number, 
					      mx_get_counters_strings_t *p);
MX_FUNC(mx_return_t) mx__nic_id_to_board_num(mx_endpt_handle_t handle,
					     mx_nic_id_to_board_num_t *p);
MX_FUNC(mx_return_t) mx__get_num_ports(mx_endpt_handle_t handle, uint32_t *p);
MX_FUNC(mx_return_t) mx__get_max_endpoints(mx_endpt_handle_t handle,
					   uint32_t *p);
MX_FUNC(mx_return_t) mx__get_logging(mx_endpt_handle_t handle,
				     mx_get_logging_t *p);
MX_FUNC(mx_return_t) mx__get_logging_strings(mx_endpt_handle_t handle,
					     uint32_t board_number, \
					     mx_get_logging_strings_t *p);
MX_FUNC(mx_return_t) mx__nic_id_to_peer_index(mx_endpt_handle_t handle,
					      mx_lookup_peer_t *p);
MX_FUNC(mx_return_t) mx__get_mapper_msgbuf_size(mx_endpt_handle_t handle,
						uint32_t *p);
MX_FUNC(mx_return_t) mx__get_mapper_mapbuf_size(mx_endpt_handle_t handle,
						uint32_t *p);
MX_FUNC(mx_return_t) mx__get_mapper_msgbuf(mx_endpt_handle_t handle, char *p);
MX_FUNC(mx_return_t) mx__get_mapper_mapbuf(mx_endpt_handle_t handle, char *p);
MX_FUNC(mx_return_t) mx__get_peer_format(mx_endpt_handle_t handle,
					 mx_get_peer_format_t *p);
MX_FUNC(mx_return_t) mx__get_route_size(mx_endpt_handle_t handle, uint32_t *p);
MX_FUNC(mx_return_t) mx__get_peer_table(mx_endpt_handle_t handle, char *p);
MX_FUNC(mx_return_t) mx__get_route_table(mx_endpt_handle_t handle,
					 mx_get_route_table_t *p);
MX_FUNC(mx_return_t) mx__get_max_peers(mx_endpt_handle_t handle, uint32_t *p);
MX_FUNC(mx_return_t) mx__pause_mapper(mx_endpt_handle_t handle,
				      uint32_t board_number);
MX_FUNC(mx_return_t) mx__resume_mapper(mx_endpt_handle_t handle,
				       uint32_t board_number);
MX_FUNC(mx_return_t) mx__raw_get_params(mx_endpt_handle_t handle,
					mx_raw_params_t *p);
MX_FUNC(mx_return_t) mx__raw_clear_routes(mx_endpt_handle_t, mx_set_route_t *p);
MX_FUNC(mx_return_t) mx__get_serial_number(mx_endpt_handle_t handle,
					   uint32_t *p);
MX_FUNC(mx_return_t) mx__get_opener(mx_endpt_handle_t handle, mx_get_opener_t *p);
MX_FUNC(mx_return_t) mx__hostname_to_nic_id(mx_endpt_handle_t handle,
					    mx_nic_id_hostname_t *p);
MX_FUNC(mx_return_t) mx__nic_id_to_hostname(mx_endpt_handle_t handle,
					    mx_nic_id_hostname_t *p);
MX_FUNC(mx_return_t) mx__clear_peer_names(mx_endpt_handle_t handle);
MX_FUNC(mx_return_t) mx__set_host_name(mx_endpt_handle_t handle,
				       mx_set_hostname_t *p);
MX_FUNC(mx_return_t) mx__get_cacheline_size(mx_endpt_handle_t handle,
					    uint32_t *p);
MX_FUNC(mx_return_t) mx__get_small_message_threshold(mx_endpt_handle_t handle,
						     uint32_t *p);
MX_FUNC(mx_return_t) mx__get_medium_message_threshold(mx_endpt_handle_t handle,
						      uint32_t *p);
MX_FUNC(mx_return_t) mx__set_route(mx_endpt_handle_t handle, mx_set_route_t *p);
MX_FUNC(mx_return_t) mx__set_route_begin(mx_endpt_handle_t handle,
					 uint32_t board_number);
MX_FUNC(mx_return_t) mx__set_route_end(mx_endpt_handle_t handle,
				       uint32_t board_number);
MX_FUNC(mx_return_t) mx__app_wait(mx_endpt_handle_t handle, mx_wait_t *p);
MX_FUNC(mx_return_t) mx__wait(mx_endpt_handle_t handle, mx_wait_t *p);
MX_FUNC(mx_return_t) mx__wait_for_recovery(mx_endpt_handle_t handle, uint32_t *status);
MX_FUNC(mx_return_t) mx__clear_wait(mx_endpt_handle_t handle);
MX_FUNC(mx_return_t) mx__wake(mx_endpt_handle_t handle);
MX_FUNC(mx_return_t) mx__app_wake(mx_endpt_handle_t handle);
MX_FUNC(mx_return_t) mx__get_irq_counters(mx_endpt_handle_t handle,
					  uint32_t board_number,
					  mx_irq_counters_t *irq);
MX_FUNC(mx_return_t) mx__run_dmabench(mx_endpt_handle_t handle,
				      mx_dmabench_t *b);
MX_FUNC(mx_return_t) mx__get_board_status(mx_endpt_handle_t handle,
					  uint32_t *p);
MX_FUNC(mx_return_t) mx__get_cpu_freq(mx_endpt_handle_t handle, uint32_t *p);
MX_FUNC(mx_return_t) mx__get_pci_freq(mx_endpt_handle_t handle, uint32_t *p);
MX_FUNC(mx_return_t) mx__set_raw(mx_endpt_handle_t handle);
MX_FUNC(mx_return_t) mx__raw_send(mx_endpt_handle_t handle, mx_raw_send_t *p);
#if MX_OS_WINNT
MX_FUNC(mx_return_t) mx__raw_ticks(mx_endpt_handle_t handle, uint32_t *p);
#endif
MX_FUNC(mx_return_t) mx__raw_get_next_event(mx_endpt_handle_t handle,
					    mx_raw_next_event_t *p);
MX_FUNC(mx_return_t) mx__set_mapper_state(mx_endpt_handle_t handle,
					  mx_mapper_state_t *);
MX_FUNC(mx_return_t) mx__get_mapper_state(mx_endpt_handle_t handle,
					  mx_mapper_state_t *);
MX_FUNC(mx_return_t) mx__get_intr_coal(mx_endpt_handle_t handle,
				       mx_intr_coal_t *p);
MX_FUNC(mx_return_t) mx__set_intr_coal(mx_endpt_handle_t handle,
				       mx_intr_coal_t *p);
MX_FUNC(mx_return_t) mx__recover_endpoint(mx_endpt_handle_t handle);
MX_FUNC(mx_return_t) mx__remove_peer(mx_endpt_handle_t handle,
				     mx_raw_destination_t *p);
MX_FUNC(mx_return_t)  mx__get_link_state(mx_endpt_handle_t handle, uint32_t *p);
MX_FUNC(mx_return_t) mx__peer_index_to_nic_id(mx_endpt_handle_t handle,
					      mx_lookup_peer_t *p);
MX_FUNC(mx_return_t) mx__direct_get(mx_endpt_handle_t handle,
				    mx_direct_get_t *p);
MX_FUNC(mx_return_t) mx__direct_getv(mx_endpt_handle_t handle,
				     mx_direct_getv_t *p);
MX_FUNC(mx_return_t) mx__wake_endpoint(mx_endpt_handle_t handle,
				       mx_wake_endpt_t *p);
MX_FUNC(mx_return_t) mx__get_product_code(mx_endpt_handle_t handle,
					  mx_get_eeprom_string_t *p);
MX_FUNC(mx_return_t) mx__get_part_number(mx_endpt_handle_t handle,
					 mx_get_eeprom_string_t *p);
MX_FUNC(mx_return_t) mx__get_version(mx_endpt_handle_t handle, mx_get_version_t *p);
MX_FUNC(mx_return_t) mx__get_sram_size(mx_endpt_handle_t handle, mx_get_board_val_t *p);
MX_FUNC(mx_return_t) mx__get_board_type(mx_endpt_handle_t handle, mx_get_board_val_t *p);
MX_FUNC(mx_return_t) mx__get_dump_reg_count(mx_endpt_handle_t handle, mx_get_board_val_t *p);
MX_FUNC(mx_return_t) mx__write_pio_req(mx_endpt_handle_t handle, mx_write_pio_req_t *p);
MX_FUNC(mx_return_t) mx__arm_timer(mx_endpt_handle_t handle, uint32_t ms);

#if MX_DRIVER_API_MAGIC >= 0x500
MX_FUNC(mx_return_t) mx__raw_set_nic_reply_info(mx_endpt_handle_t handle, mx_raw_set_nic_reply_info_t *p);
#endif

MX_FUNC(mx_return_t) mx__pci_cfg_read(mx_endpt_handle_t handle, mx_pci_cfg_t *p);
MX_FUNC(mx_return_t) mx__pci_cfg_write(mx_endpt_handle_t handle, mx_pci_cfg_t *p);

#endif

